/*
Easy Bones Creation MacroScript File

 Created:  		April 18 2000

 Author :   Frank DeLise
 Version:  3ds max 4

 IK tools
 This script increases workflow on Bones and IK.
 
 
 Revision History:
 
	11 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macroscript file can be shared with all Discreet products

 
*/
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK



macroScript Bones 
category:~BONES_CATEGORY~ 
internalCategory:"Inverse Kinematics" 
tooltip:~BONES_TOOLTIP~ 
buttontext:~BONES_BUTTONTEXT~ 
Icon:#("MainToolbar",49)
(
    on execute do  StartObjectCreation Bones 
    on isChecked return mcrUtils.IsCreating Bones 
)


MacroScript Auto_Bones
ButtonText:~AUTO_BONES_BUTTONTEXT~
Category:~AUTO_BONES_CATEGORY~ --pfb: 2003.12.11 falls under the animation tools, just like the Bones Tools dialog
internalCategory:"Animation Tools"  --pfb: 2003.12.11 falls under the animation tools, just like the Bones Tools dialog
Tooltip:~AUTO_BONES_TOOLTIP~ 
Icon:#("MainToolbar",49)

(

	On Execute do
	(
		If ABone_Roll != undefined then Try(DestroyDialog ABone_Roll)Catch() 
		Rollout ABone_Roll ~AUTO_BONES_OPTIONS~
		(
			CheckBox ABone_ON ~BONE_ON_OFF~ Across:2 Checked:False Width:~BONE_ON_OFF_WIDTH~
			CheckBox ABone_Auto ~AUTO_ALIGN~ Width:~AUTO_ALIGN_WIDTH~ Across:2 Enabled:False Checked:False
			Button ABone_ReAlign ~REALIGN~ Width:~ABONE_REALIGN_WIDTH~ Align:~ABONE_REALIGN_ALIGN~ offset:~AUTO_BONES_OFFSET~
			Button ABone_ResetStretch ~ABONE_RESETSTRETCH~ Width:~ABONE_RESETSTRETCH_WIDTH~ Align:~ABONE_RESETSTRETCH_ALIGN~ Offset:~ABONE_RESETSTRETCH_OFFSET~ Enabled:False
			CheckBox ABone_Freeze ~ABONE_FREEZE_CAPTION~ Enabled:False Checked:False
			RadioButtons ABone_ScaleType Labels:#(~SCALE~, ~SQUASH~, ~NONE~) Enabled:False columns:~ABONE_SCALETYPE_COLUMNS~
			CheckBox ABone_SLinks ~ABONE_SLINKS~ Across:~ABONE_SLINKS_ACROSS~ Checked:False
			CheckBox ABone_LinksOnly ~ABONE_LINKSONLY~ Across:~ABONE_LINKSONLY_ACROSS~ Checked:False Offset:~ABONE_LINKSONLY_OFFSET~
			Button ABone_Sel ~ABONE_SEL~ Width:~ABONE_SEL_WIDTH~
			Label ABone_1 "----" 
		
			
		
			fn Eval_ABone = 
			(
				Try(
				For i in 1 to Selection.count do
				(
					Selection[i].SetBoneEnable ABone_On.Checked SliderTime
					Selection[i].BoneAutoAlign = ABone_Auto.Checked
					Selection[i].BoneFreezeLength = ABone_Freeze.Checked
					Selection[i].ShowLinks = ABone_SLinks.Checked
					Selection[i].ShowLinksOnly = ABone_LinksOnly.Checked
					
					Case ABone_ScaleType.State of
					(
						1:(Selection[i].BoneScaleType = #Scale)
						2:(Selection[i].BoneScaleType = #Squash) 
						3:(Selection[i].BoneScaleType = #None)  
					)
					ABone_1.text = (~AUTO_BONED~ + i as string + ~OBJECTS~)
				)
				If Selection.Count == 0 then ABone_1.text = (~NO_OBJECTS_SELECTED~)
				)
				Catch()
			) 
			
			On ABone_SLinks Changed State do (Eval_ABone();completeRedraw()  )
			On ABone_LinksOnly Changed State do (Eval_ABone();completeRedraw()  )
			
			On ABone_Sel Pressed Do (Eval_ABone())
			On Abone_On Changed State Do
			(
				ABone_Auto.Enabled = State
				ABone_ResetStretch.Enabled = State
				ABone_Freeze.Enabled = State
				ABone_ScaleType.Enabled = State
				ABone_1.Enabled = State
				Eval_ABone ()
			)
			On ABone_Freeze Changed State Do (Eval_ABone())
			On ABone_ScaleType Changed State Do (Eval_ABone())
			On ABone_Auto Changed State Do (Eval_ABone())
			On ABone_ReAlign Pressed do 
			(	
				For i in 1 to Selection.count do
				(
					Try(
					Selection[i].ReAlignBoneToChild ()
					ABone_1.text = (~REALIGNED~ + i as string + ~ABONE_1_OBJECTS~)
					)Catch()
				)
				If Selection.Count == 0 then ABone_1.text = (~ABONE_1_NO_OBJECTS_SELECTED~)
			)
			On ABone_ResetStretch Pressed do 
			(
				
				For i in 1 to Selection.count do
				(
					Try(
					Selection[i].ResetBoneStretch ()
					ABone_1.text = (~RESET_STRETCH_ON~ + i as string + ~ABONE_1_OBJECTS_CAPTION~)
					)Catch()
				)
				If Selection.Count == 0 then ABone_1.text = (~ABONE_1_NO_OBJECTS_SELECTED_TEXT~)
				
			)
			
			
	)
		CreateDialog ABone_Roll Pos:[150,150] Width:~ABONE_ROLL_WIDTH~ height:~ABONE_ROLL_HEIGHT~
		
	
)

)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAYvyBzc03UcPGpP/CN2mVGHAbgf7Owcvm6
-- XQ80Vxl2MGCWlSG1Yo7Z5K0BidTKJxJ5msfqVgoAbyl2wNnuDEm4gSP3SUMqBhnG
-- mSRpwq2DnTnGFKJF0oa4t3ctoJ/pnVXKxxxbRkBkrYvmBUNG3w2GvGPOk4bmA91r
-- pzOoEiMXU09aro8KICv8gP0IVq3z0Yoa2HZrKB63ChwhdorrUs66sKWo6ucoqdDo
-- 2Tjge7OkjcIOcRiLebZos1iZ9ljp1DHGZCbuaXvgn1eJOVgAYhICUYBSXgFnLlI9
-- stCI1b8Oe5KyIpcKrX74i6B6KrLM06iCI+//X/vSqrz+qrgGceJr
-- -----END-SIGNATURE-----